<!---
CMake build script for ACM Collected Algorithms: DCUHRE and DQUAD
Copyright (C) 2022  Tim Haase

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this program.  If not, see
<https://www.gnu.org/licenses/>.
--->

# ACM Collected Algorithms: DCUHRE and DQUAD #

This project provides a CMake framework, that automatically downloads the two
Fortran integrator libraries DCUHRE and DQUAD from the ACM Collected Algorithms
(<https://calgo.acm.org/>), converts them to C and builds them.

## Prerequisites ##

What you need:

- [Git](https://git-scm.com/) (optional) for getting the code and contributing
  to the project
- [CMake](https://cmake.org/) for building the project
- C compiler
  - gcc for linux/mac (<https://gcc.gnu.org/>)
  - cygwin + gcc for windows (<https://www.cygwin.com/>)
- NetlibF2C (<https://gitlab.aei.uni-hannover.de/netlib/netlib-f2c>)

### Linux (Ubuntu) ###

Use your distribution's package manager to install the packages `cmake` and
`gcc`.

```shell
$ sudo apt-get install cmake gcc
```

### Mac OS X ###

#### Homebrew ####

```shell
$ brew install cmake gcc
```

#### MacPorts ####

```shell
$ sudo port install cmake gcc
```

### Windows ###

Install Cygwin and use the Cygwin package manager to install the packages
`cmake` and `gcc-core`.

## How to compile ##

1. (Optional) First, build the NetlibF2C project and install it either
   system-wide or in a central location, e. g. somewhere in your home directory.
   Please refer to the project README for build instructions. If you skip this
   step, NetlibF2C should automatically be downloaded and included in your
   build. But you might end up compiling some parts multiple times
   unnecessarily.
2. Clone this git repository or download the source code archive and unpack it
   to an arbitrary directory (e.g. `calgo-integrators`).
3. Go to this directory and type `cmake --preset shared`, if you installed
   NetlibF2C system-wide or not at all. Otherwise, type

   ```shell
   $ cmake -DCMAKE_PREFIX_PATH=/path/to/NetlibF2C/install/prefix --preset shared
   ```

   Replace the path to the NetlibF2C install prefix with the actual path on your
   system! The license of the ACM Collected Algorithms (CALGO) will be shown to
   you. If you accept this license, add the required variable to the previous
   command:

   ```shell
   $ cmake -DCalgoIntegrators_LICENSE_ACCEPTED=YES --preset shared
   ```

   or

   ```shell
   $ cmake -DCMAKE_PREFIX_PATH=/path/to/NetlibF2C/install/prefix -DCalgoIntegrators_LICENSE_ACCEPTED=YES --preset shared
   ```

   If not installed previously, you will also have to accept NetlibF2C's license
   in a similar way. This will populate the `./build/shared` directory with a
   CMake build tree.
4. Now, you can build with `cmake --build ./build/shared`. You should see some
   informative terminal output.
5. Finally, install the built artifacts to the `bin` folder with `cmake
   --install ./build/shared --prefix ./bin`. You can also specify a different
   install prefix, e. g. if you want to install system-wide: `cmake --install
   ./build/shared --prefix /usr/local` (might require `sudo`). You can also
   install either only the DCUHRE library or only the DQUAD library with `cmake
   --install ./build/shared --prefix <any> --component dcuhre` or `cmake
   --install ./build/shared --prefix <any> --component dquad`
6. Repeat steps 3. - 5. with `cmake --preset static` and the build directory
   `./build/static`.

Now, the integrator code is compiled and you can use it in other projects. The
installed integrator package is discoverable by CMake as __CalgoIntegrators__.
In the `CMakeLists.txt` of the other project, call:

```cmake
find_package(CalgoIntegrators CONFIG REQUIRED)
```

This makes two CMake targets available to you, the `Netlib::DCUHRE` and the
`Netlib::DQUAD` library targets (static or shared depends on the value of
`BUILD_SHARED_LIBS` in the other project). The `Netlib::libf2c` is already
contained in these targets.

Then, to help CMake discover the CalgoIntegrators package, call CMake for the
other project like this:

```shell
$ cmake -B ./build -DCMAKE_PREFIX_PATH="/path/to/CalgoIntegrators/install/prefix"
```

Replace the path to the CalgoIntegrators install prefix with the actual path on
your system! If CalgoIntegrators is installed in a proper system-wide location,
the `CMAKE_PREFIX_PATH` shouldn't be necessary.

For more information read the two papers referenced below.

## References ##

Paola Favati, Grazia Lotti, and Francesco Romani. 1991. Algorithm 691: Improving
QUADPACK automatic integration routines. ACM Trans. Math. Softw. 17, 2 (June
1991), 218–232. DOI:<https://dl.acm.org/doi/10.1145/108556.108580>

Jarle Berntsen, Terje O. Espelid, and Alan Genz. 1991. Algorithm 698: DCUHRE: an
adaptive multidemensional integration routine for a vector of integrals. ACM
Trans. Math. Softw. 17, 4 (Dec. 1991), 452–456.
DOI:<https://dl.acm.org/doi/10.1145/210232.210234>
