/*
 * CMake build script for ACM Collected Algorithms: DCUHRE and DQUAD
 * Copyright (C) 2022  Tim Haase
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

#ifndef _DCUHRE_H
#define _DCUHRE_H

#include "f2c.h"

#ifdef __cplusplus
extern "C"
{
#endif

  int dcuhre_ (integer *ndim, integer *numfun, doublereal *a, doublereal *b,
               integer *minpts, integer *maxpts, U_fp funsub,
               doublereal *epsabs, doublereal *epsrel, integer *key,
               integer *nw, integer *restar, doublereal *result,
               doublereal *abserr, integer *neval, integer *ifail,
               doublereal *work);

  int scuhre_ (integer *ndim, integer *numfun, real *a, real *b,
               integer *minpts, integer *maxpts, U_fp funsub, real *epsabs,
               real *epsrel, integer *key, integer *nw, integer *restar,
               real *result, real *abserr, integer *neval, integer *ifail,
               real *work);

#ifdef __cplusplus
}
#endif

#endif /*_DCUHRE_H */
