/*
 * CMake build script for ACM Collected Algorithms: DCUHRE and DQUAD
 * Copyright (C) 2024  Tim Kaune
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

#ifndef _DQUAD_H
#define _DQUAD_H

#include "f2c.h"

#ifdef __cplusplus
extern "C"
{
#endif

  int dqxgs_ (D_fp f, doublereal *a, doublereal *b, doublereal *epsabs,
              doublereal *epsrel, doublereal *result, doublereal *abserr,
              integer *ier, integer *limit, integer *leniw, integer *lenw,
              integer *last, integer *iwork, doublereal *work);

  int dqxg_ (D_fp f, doublereal *a, doublereal *b, doublereal *epsabs,
             doublereal *epsrel, integer *key, doublereal *result,
             doublereal *abserr, integer *ier, integer *limit, integer *leniw,
             integer *lenw, integer *last, integer *iwork, doublereal *work);

  int qxgs_ (E_fp f, real *a, real *b, real *epsabs, real *epsrel,
             real *result, real *abserr, integer *ier, integer *limit,
             integer *leniw, integer *lenw, integer *last, integer *iwork,
             real *work);

  int qxg_ (E_fp f, real *a, real *b, real *epsabs, real *epsrel, integer *key,
            real *result, real *abserr, integer *ier, integer *limit,
            integer *leniw, integer *lenw, integer *last, integer *iwork,
            real *work);

#ifdef __cplusplus
}
#endif

#endif /*_DQUAD_H */
