from pycbc.waveform import get_fd_waveform
import numpy as np
import pycbc.conversions
import lal

def IMRPhenomParity(parity_Amu, **kwds):

    if 'approximant' in kwds:
        kwds.pop("approximant")
    hp, hc = get_fd_waveform(approximant="IMRPhenomXPHM", **kwds)

    temp =  parity_Amu * 1e9 * lal.QE_SI * lal.PI * lal.PI / lal.H0_SI

    hp_parity = hp + hc * temp * hp.sample_frequencies **2
    hc_parity = hc - hp * temp * hp.sample_frequencies **2    

    return hp_parity, hc_parity
